/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.ponder.foundation.element;

import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.gui.element.AbstractRenderElement;
import net.createmod.catnip.gui.element.BoxElement;
import net.createmod.catnip.theme.Color;
import net.createmod.ponder.api.PonderPalette;
import net.createmod.ponder.api.element.TextElementBuilder;
import net.createmod.ponder.foundation.PonderIndex;
import net.createmod.ponder.foundation.PonderScene;
import net.createmod.ponder.foundation.element.AnimatedOverlayElementBase;
import net.createmod.ponder.foundation.ui.PonderUI;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5348;

public class TextWindowElement
extends AnimatedOverlayElementBase {
    public static final Couple<Color> COLOR_WINDOW_BORDER = Couple.create(new Color(1618632704, true), new Color(544890880, true)).map(Color::setImmutable);
    Supplier<String> textGetter = () -> "(?) No text was provided";
    @Nullable
    String bakedText;
    int y;
    @Nullable
    class_243 vec;
    boolean nearScene = false;
    PonderPalette palette = PonderPalette.WHITE;

    public TextElementBuilder builder(PonderScene scene) {
        return new Builder(scene);
    }

    @Override
    public void render(PonderScene scene, PonderUI screen, class_332 graphics, float partialTicks, float fade) {
        if (this.bakedText == null) {
            this.bakedText = this.textGetter.get();
        }
        if (fade < 0.0625f) {
            return;
        }
        PonderScene.SceneTransform transform = scene.getTransform();
        class_241 sceneToScreen = this.vec != null ? transform.sceneToScreen(this.vec, partialTicks) : new class_241((float)screen.field_22789 / 2.0f, (float)(screen.field_22790 - 200) / 2.0f + (float)this.y - 8.0f);
        boolean settled = transform.xRotation.settled() && transform.yRotation.settled();
        float pY = settled ? (float)((int)sceneToScreen.field_1342) : sceneToScreen.field_1342;
        float yDiff = ((float)screen.field_22790 / 2.0f - sceneToScreen.field_1342 - 10.0f) / 100.0f;
        float targetX = (float)screen.field_22789 * class_3532.method_16439((float)(yDiff * yDiff), (float)0.75f, (float)0.625f);
        if (this.nearScene) {
            targetX = Math.min(targetX, sceneToScreen.field_1343 + 50.0f);
        }
        if (settled) {
            targetX = (int)targetX;
        }
        int textWidth = (int)Math.min((float)screen.field_22789 - targetX, 180.0f);
        List lines = screen.getFontRenderer().method_27527().method_27498(this.bakedText, textWidth, class_2583.field_24360);
        int boxWidth = 0;
        for (class_5348 line : lines) {
            boxWidth = Math.max(boxWidth, screen.getFontRenderer().method_27525(line));
        }
        int boxHeight = screen.getFontRenderer().method_1713(this.bakedText, boxWidth);
        class_4587 poseStack = graphics.method_51448();
        poseStack.method_22903();
        poseStack.method_46416(0.0f, pY, 400.0f);
        ((AbstractRenderElement)((BoxElement)new BoxElement().withBackground(PonderUI.BACKGROUND_FLAT)).gradientBorder(COLOR_WINDOW_BORDER)).at(targetX - 10.0f, 3.0f, -101.0f).withBounds(boxWidth, boxHeight - 1).render(graphics);
        Color brighter = this.palette.getColorObject().mixWith(new Color(-35), 0.5f).setImmutable();
        Color c1 = new Color(-11974327);
        Color c2 = new Color(-13027015);
        if (this.vec != null) {
            poseStack.method_22903();
            poseStack.method_46416(sceneToScreen.field_1343, 0.0f, 0.0f);
            double lineTarget = (targetX - sceneToScreen.field_1343) * fade;
            poseStack.method_22905((float)lineTarget, 1.0f, 1.0f);
            graphics.method_33284(0, 0, 1, 1, -100, brighter.getRGB(), brighter.getRGB());
            graphics.method_33284(0, 1, 1, 2, -100, c1.getRGB(), c2.getRGB());
            poseStack.method_22909();
        }
        poseStack.method_46416(0.0f, 0.0f, 400.0f);
        for (int i = 0; i < lines.size(); ++i) {
            graphics.method_51433(screen.getFontRenderer(), ((class_5348)lines.get(i)).getString(), (int)(targetX - 10.0f), 3 + 9 * i, brighter.scaleAlphaForText(fade).getRGB(), false);
        }
        poseStack.method_22909();
    }

    public PonderPalette getPalette() {
        return this.palette;
    }

    private class Builder
    implements TextElementBuilder {
        private final PonderScene scene;

        public Builder(PonderScene scene) {
            this.scene = scene;
        }

        @Override
        public Builder colored(PonderPalette color) {
            TextWindowElement.this.palette = color;
            return this;
        }

        @Override
        public Builder pointAt(class_243 vec) {
            TextWindowElement.this.vec = vec;
            return this;
        }

        @Override
        public Builder independent(int y) {
            TextWindowElement.this.y = y;
            return this;
        }

        @Override
        public Builder text(String defaultText) {
            TextWindowElement.this.textGetter = this.scene.registerText(defaultText);
            return this;
        }

        @Override
        public TextElementBuilder text(String defaultText, Object ... params) {
            TextWindowElement.this.textGetter = this.scene.registerText(defaultText, params);
            return this;
        }

        @Override
        public Builder sharedText(class_2960 key) {
            TextWindowElement.this.textGetter = () -> PonderIndex.getLangAccess().getShared(key);
            return this;
        }

        @Override
        public TextElementBuilder sharedText(class_2960 key, Object ... params) {
            TextWindowElement.this.textGetter = () -> PonderIndex.getLangAccess().getShared(key, params);
            return this;
        }

        @Override
        public Builder sharedText(String key) {
            return this.sharedText(new class_2960(this.scene.getNamespace(), key));
        }

        @Override
        public TextElementBuilder sharedText(String key, Object ... params) {
            return this.sharedText(new class_2960(this.scene.getNamespace(), key), params);
        }

        @Override
        public Builder placeNearTarget() {
            TextWindowElement.this.nearScene = true;
            return this;
        }

        @Override
        public Builder attachKeyFrame() {
            this.scene.builder().addLazyKeyframe();
            return this;
        }
    }
}

